﻿/* Skript zur Demonstration von Indizes
 * Als Benutzer HR ausführen
 */
 

-- Beispiel der Erzeugung von Textindizes
-- Erstellung einer Beispieltabelle:
create table employee_search as
select e.employee_id, e.first_name, e.last_name, e.email,
       d.department_name, l.city, l.state_province
  from employees e
  join departments d on e.department_id = d.department_id
  join locations l on d.location_id = l.location_id;
  
  
-- Suche über mehrere Spalten
select *
  from employee_search
 where lower(first_name) like '%fran%'
    or lower(last_name) like '%fran%'
    or lower(department_name) like '%fran%'
    or lower(city) like '%fran%';

-- Erstellung eines Kontextindexes
create index idx_emp_search
    on employees(last_name)
indextype is ctxsys.context
parameters ('filter ctxsys.null_filter');
 
-- Abfrage, die den Volltextindex benutzt
select *
  from employees
 where contains(last_name, '%ran%', 1) > 0;

-- Synchronisierung eines Volltextindexes
-- Erforderlich ist ein execute-Recht auf ctx_ddl!
call ctx_ddl.sync_index('idx_emp_search', '2M');

create table text_content(
  id number,
  text blob);